package gov.va.genisis2.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;


/**
 * The Class UserApprover.
 * 
 * Description: In this UserApprover Class implements the interface Serializable
 * and defines the entity and data mapping for the dbo.User_Approver Table in
 * the database.
 * 
 */
@Entity
@Table(name = "User_Approver", schema = "dbo")
public class UserApprover implements Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 4004763796568945048L;

	/** The id. */
	@Id
	@Column(name = "Id", unique = true, nullable = false)
	private int id;
	
	/** The user approver id. */
	@Column(name = "User_Approver_id", nullable = false, insertable = false, updatable = false)
	private int userApproverId;
	
	/** The users by user approver id. */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "User_Approver_id", nullable = false)
	private User usersByUserApproverId;
	
	/** The user id. */
	@Column(name = "User_id", nullable = false, insertable = false, updatable = false)
	private int userId;

	/** The users by user id. */
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "User_id", nullable = false)
	private User usersByUserId;

	/**
	 * Gets the id.
	 *
	 * @return the id
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Sets the id.
	 *
	 * @param id the new id
	 */
	public void setId(int id) {
		this.id = id;
	}
	
	public int getUserApproverId() {
		return userApproverId;
	}
	
	public void setUserApproverId(int userApproverId) {
		this.userApproverId = userApproverId;
	}

	/**
	 * Gets the users by user approver id.
	 *
	 * @return the users by user approver id
	 */
	public User getUsersByUserApproverId() {
		return this.usersByUserApproverId;
	}

	/**
	 * Sets the users by user approver id.
	 *
	 * @param usersByUserApproverId the new users by user approver id
	 */
	public void setUsersByUserApproverId(User usersByUserApproverId) {
		this.usersByUserApproverId = usersByUserApproverId;
	}
	
	public int getUserId() {
		return userId;
	}
	
	public void setUserId(int userId) {
		this.userId = userId;
	}

	/**
	 * Gets the users by user id.
	 *
	 * @return the users by user id
	 */
	public User getUsersByUserId() {
		return this.usersByUserId;
	}

	/**
	 * Sets the users by user id.
	 *
	 * @param usersByUserId the new users by user id
	 */
	public void setUsersByUserId(User usersByUserId) {
		this.usersByUserId = usersByUserId;
	}

}
